/*------------------------------------------------------------------------------*
 * File Name:SaveFormatAsTheme.c												*
 * Creation: CPY																*
 * Purpose: OriginC Source C file for Save Format As Theme Dialog				*
 * Copyright (c) Originlab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Danice 8/11/04 QA70-6638 v8.0114 USER_THEME_WILL_NOT_CORVER_EXE_THEME		*
 * SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H					*
 * DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE										*
 *	CPY 2/21/05 THEME_SAVE_FORMAT_WKS, added m_nPageType						*
 *	DSC 2/23/05 v8.0197 QA70-7416 ADD_THEME_TYPES								*
 *  DG 7/8/05 v8.0263 ENABLE_RESIZING											*
 *	Frank 9/13/05 v8.0305 REMOVE_DIALOGEX_FROM_THEME_ULTILS						*
 *  Sophy 10/28/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE				*
 *	Hong QA80-11640 v8.0982b SUPPORT_DRAG_AND_DROP_THEME_FOR_EASY_SHARING		*
 *	Jasmine 02/10/10 QA81-15101 SHOW_EXIST_THEMES								*
 *	Bill 08/03/2010 ORG-699-P1 SAVE_CHECKBOX_STATUS								*
 *	Bill 08/05/2010 ORG-699-P3 THE_HEIGHT_OF_TREECONTROL_INCREASE_AUTOMATICALLY *
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
//#include <Project.h>
//#include <sys_utils.h> // basic routines implemeted through Origin C, see sys_utils.c
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///	#include <Dialog.h>
#include "DialogEx.h"     // Dialog class
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
//#include <utilities.h>
//#include <tree_utils.h>
///	#include "ResizeDialog.h" /// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
#include <TreeEditor.h>
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///	#include <vsFlexGrid.h>
///	#include "ODlg.h" // resource IDs, ODlg.dll also use this file for its res ids
///	#include "HelpID.h"
///	#include "theme_utils.h"
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H

///DSC 1/11/07 REMOVE_LOCAL_H #include "$Local.h"     // Localized definitions

/// Hong QA80-11640 v8.0982b SUPPORT_DRAG_AND_DROP_THEME_FOR_EASY_SHARING
// move to theme_utils.h
//#define STR_SAVE_THEME_CAPTION		_L("Theme Saving")
//#define STR_SAVE_THEME_ASK_REPLACE	_L("The named theme file already existed, do you want to replace it?")
//#define STR_SAVE_THEME_BAD_FILENAME _L("The specified theme name is not a valid file name.")
/// end SUPPORT_DRAG_AND_DROP_THEME_FOR_EASY_SHARING

///DG ENABLE_RESIZING
#define MIN_TREE_HEIGHT			300
///end ENABLE_RESIZING

/// Bill 08/03/2010 ORG-699-P1 SAVE_CHECKBOX_STATUS
#define STR_DLG_NAME "Save Format As Theme"

#define STR_ADVANCED 	"Advance"
#define STR_ALL_STYLE	"AllStyle"
#define STR_ALL 		"All"
#define STR_FONTS 		"Fonts"
#define STR_COLORS		"Colors"
#define STR_PLOTS		"Plots"
#define STR_DIMENSION	"Dimension"
#define STR_SCALE		"Scale"
#define STR_BKGROUND	"BkGround"
#define STR_TEXT		"Text"
#define STR_COLLECTIONS	"Collections"
#define STR_LIST_VIEW	"ListView"

/// End SAVE_CHECKBOX_STATUS

class SaveThemeDlg : public ResizeDialog
{
public:
	SaveThemeDlg() : ResizeDialog(IDD_SAVE_THEME, "ODlg")
	{
		///DSC 2/23/05 7416 ADD_THEME_TYPES
		//-- get page type
		Page pg = Project.Pages();
		int nPageType;
		if(!pg)
			nPageType = EXIST_NONE;
		else
			nPageType = pg.GetType();		
				
		//-- get theme type
		m_nThemeType = theme_get_type_from_page_type(nPageType);
		///end ADD_THEME_TYPES
		
		string strThemeFileName;
		if(theme_get_next_file_name(strThemeFileName, true, m_nThemeType))
			m_strThemeName = GetFileName(strThemeFileName, true);
		
	}
	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();// will be called from internal later
		int nRet = DoModal(hWndParent);
		
		return nRet;
	}
private:
	int 	m_nThemeType; ///DSC 2/23/05 QA70-7416 ADD_THEME_TYPES
	int		m_nPageType; //CPY 2/21/05 THEME_SAVE_FORMAT_WKS
	string	m_strThemeFileAllFormats;
	string	m_strThemeName;

	// controls
	TreeEditor	m_tree;
	///Jasmine 02/10/10 QA81-15101 SHOW_EXIST_THEMES
	//Edit		m_editName;
	ComboBox	m_cmbName;
	///End SHOW_EXIST_THEMES
	Edit		m_editDescription;
	//Button 		m_btnCheckAdvanced;
	//bool		m_btnCheckAdvanced;
	BitmapRadioButton	m_btnCheckAdvanced;
	
	Control 	m_cntrlOldSystemTheme;
	Control		m_cntrlSimpleGroup; 
	Button		m_chkAll;
	Button		m_chkAllStyles;
	Button		m_chkFonts;
	Button		m_chkColors;
	Button		m_chkPlots; // symbol line fill
	Button		m_chkDimension;
	Button		m_chkScale;
	Button		m_chkBkground;
	Button		m_chkText;
	
protected:
	EVENTS_BEGIN
		ON_INIT(OnInitDialog) 
		ON_OK(OnOK)
		ON_SIZE(OnDlgResize)	///DG ENABLE_RESIZING
		ON_BN_CLICKED(IDC_SAVETHEME_CUSTOM, OnAdvancedCheck)
		ON_BN_CLICKED(IDC_SAVETHEME_LIST_VIEW, OnCheck)
		ON_BN_CLICKED(IDC_SAVETHEME_COLLECTIONS, OnCheck)
		ON_BN_CLICKED(IDC_SAVETHEME_FILTER, OnThemeFilter)
		ON_BN_CLICKED(IDC_SAVETHEME_ALL, OnSimpleGroupCheck)
		ON_BN_CLICKED(IDC_SAVETHEME_ALL_STYLES, OnSimpleGroupCheck) 
		ON_DESTROY(OnDestroy)
		///Jasmine 02/10/10 QA81-15101 SHOW_EXIST_THEMES
		//ON_EN_CHANGE(IDC_SAVETHEME_NAME, OnNameChange)
		ON_CBN_EDITCHANGE(IDC_SAVETHEME_NAME, OnNameChange)
		ON_CBN_SELCHANGE(IDC_SAVETHEME_NAME, OnSelName)
		///End SHOW_EXIST_THEMES
	EVENTS_END
	
	BOOL OnInitDialog()
	{
		waitCursor junk;
		ResizeDialog::OnInitDialog();
		SetControlGap(12);	///DG ENABLE_RESIZING : The old unresizable one gap is large
		
		m_tree = GetItem(IDC_SAVETHEME_TREE);
		///Jasmine 02/10/10 QA81-15101 SHOW_EXIST_THEMES
		//m_editName = GetItem(IDC_SAVETHEME_NAME);
		//m_editName.Text = m_strThemeName;
		initThemeNameList();
		///End SHOW_EXIST_THEMES
		m_editDescription = GetItem(IDC_SAVETHEME_DESCRIPTION);
		
		m_btnCheckAdvanced = GetItem(IDC_SAVETHEME_CUSTOM);
		
		vector<string>  vstrTipsUpDown;
		vstrTipsUpDown.Add(_L("Edit theme details"));
		vstrTipsUpDown.Add(_L("Cancel edit"));
		m_btnCheckAdvanced.Init(2, IDB_EDIT_DOWNUP, 37, vstrTipsUpDown);
		//m_btnCheckAdvanced = false;

		m_chkAll = GetItem(IDC_SAVETHEME_ALL);
		m_chkAllStyles = GetItem(IDC_SAVETHEME_ALL_STYLES);
		m_chkFonts = GetItem(IDC_SAVETHEME_FONTS);
		m_chkColors = GetItem(IDC_SAVETHEME_COLORS);
		m_chkPlots = GetItem(IDC_SAVETHEME_DATAPLOT);
		m_chkDimension = GetItem(IDC_SAVETHEME_DIMS);
		m_chkScale = GetItem(IDC_SAVETHEME_SCALES);
		m_chkBkground = GetItem(IDC_SAVETHEME_BACKGROUD);
		m_chkText = GetItem(IDC_SAVETHEME_TEXT);
		
		/// Bill 08/03/2010 ORG-699-P1 SAVE_CHECKBOX_STATUS
		m_cntrlOldSystemTheme = GetItem(IDC_SAVETHEME_CURRENT_SYSTEM);
		m_cntrlOldSystemTheme.Text = okutil_theme_get_system_theme(m_nThemeType);
		
		m_cntrlSimpleGroup = GetItem(IDC_SAVETHEME_SIMPLE_GROUP);

		LoadControl();

		//m_chkAll.Check = true;
		/// End SAVE_CHECKBOX_STATUS

		updateSimpleGroup();
		
		show_controls(m_btnCheckAdvanced.Check);
		
		copyThemeAllFormats();
		if(m_btnCheckAdvanced.Check)
			load_theme_to_tree();

		//m_wndDlg.CheckRadioButton(IDC_SAVETHEME_ALL, IDC_SAVETHEME_SCALES, save_format_type_to_radio(m_nSaveFormatType));
		
		/// Bill 08/03/2010 ORG-699-P1 SAVE_CHECKBOX_STATUS
		/*
		m_cntrlOldSystemTheme = GetItem(IDC_SAVETHEME_CURRENT_SYSTEM);
		m_cntrlOldSystemTheme.Text = okutil_theme_get_system_theme(m_nThemeType);
		
		m_cntrlSimpleGroup = GetItem(IDC_SAVETHEME_SIMPLE_GROUP);
		*/
		/// End SAVE_CHECKBOX_STATUS
		return TRUE;	
	}
	BOOL OnOK()
	{
		if(m_strThemeName.IsEmpty())
			return FALSE;
		if(!is_str_valid_for_filename(m_strThemeName))
		{
			MessageBox(GetSafeHwnd(), STR_SAVE_THEME_BAD_FILENAME, STR_SAVE_THEME_CAPTION, MB_OK);
			return FALSE;
		}
		string strTempThemeFilename;
		GetTempFileName(strTempThemeFilename);
		
		if(m_btnCheckAdvanced.Check)
			m_tree.Save(strTempThemeFilename);
		else
			getFormatsBySimpleGroup(strTempThemeFilename);

		if(strTempThemeFilename.IsFile())
		{
			// description
			string	strComments;
			if(hasDescription(strComments))
			{
				Tree trTemp(strTempThemeFilename);
				trTemp.SetAttribute(STR_THEME_COMMENT_ATTRIB, strComments);
				trTemp.Save(strTempThemeFilename);
			}
			///Danice USER_THEME_WILL_NOT_CORVER_EXE_THEME
			//string strThemeFileEXE = theme_get_theme_file_name(m_strThemeName, true);
			string strThemeFile = okutil_theme_get_theme_file_name(m_strThemeName, m_nThemeType);
			
			string strPathOnly = GetFilePath(strThemeFile);
			if(CheckMakePath(strPathOnly))
			{		
				//if((strThemeFile.IsFile() || strThemeFileEXE.IsFile()) && MessageBox(GetSafeHwnd(), STR_SAVE_THEME_ASK_REPLACE, STR_SAVE_THEME_CAPTION, MB_OKCANCEL) == IDCANCEL)
				if(strThemeFile.IsFile() && MessageBox(GetSafeHwnd(), STR_SAVE_THEME_ASK_REPLACE, STR_SAVE_THEME_CAPTION, MB_OKCANCEL) == IDCANCEL)
				{
					DeleteFile(strTempThemeFilename);///dsc 
					return FALSE;
				}
				///end USER_THEME_WILL_NOT_CORVER_EXE_THEME
				///Sophy 10/24/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE    
				//CopyFile(strTempThemeFilename, strThemeFile);
				if( !CopyFile(strTempThemeFilename, strThemeFile) )
					popup_errmsg_save_readonly_file( strThemeFile, GetSafeHwnd() );
				///end SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
				
				Button cSetSys = GetItem(IDC_SAVETHEME_SET_SYSTEM);
				if(cSetSys.Check)
				{
					///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE
					// theme_system_getset(m_strThemeName, true, true, false);
					theme_system_getset(m_strThemeName, true, true, ORIGIN_PATH_USER, m_nThemeType);///DSC 2/23/05
					///end USE_ENUM_ORIGIN_PATH_TYPE
				}
		
				DeleteFile(strTempThemeFilename);
				return TRUE;
			}
			else
			{
				DeleteFile(strTempThemeFilename);
				return false;
			}
		}
		out_str("Err, Save Theme dialog error!");
		return TRUE;
	}

	///DG 7/8/05 ENABLE_RESIZING
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		bool bSimpleView = m_cntrlSimpleGroup.Visible;
		
		uint nBtns[]={IDOK, IDCANCEL, IDC_SAVETHEME_CUSTOM, IDC_SAVETHEME_FILTER, IDC_SAVETHEME_LIST_VIEW, IDC_SAVETHEME_COLLECTIONS, 0};
		RECT rbtn;
		GetControlClientRect(nBtns[0], rbtn);
		int nWidth = RECT_WIDTH(rbtn), nEdge = GetControlGap();
		int nx = cx-nWidth-nEdge, ny = nEdge;
		ArrangeControlsTopDown(nBtns, nx, ny);
		
		if(!bSimpleView)
		{
			RECT r1;
			m_tree.GetWindowRect(&r1);
			m_wndDlg.ScreenToClient(&r1);
			
			r1.right=nx - 2*nEdge;
			/// Bill 08/05/2010 ORG-699-P3 THE_HEIGHT_OF_TREECONTROL_INCREASE_AUTOMATICALLY
			//r1.bottom=cy;
			r1.bottom = cy - nEdge;
			/// End THE_HEIGHT_OF_TREECONTROL_INCREASE_AUTOMATICALLY
			MoveControl(m_tree, r1);
			//StretchControlWide(IDC_SAVETHEME_TREE, r1.left, r1.top, RECT_WIDTH(r1), 0);
		}
		return true;
	}
	///end ENABLE_RESIZING
	BOOL OnDestroy(void)
	{
		/// Bill 08/03/2010 ORG-699-P1 SAVE_CHECKBOX_STATUS
		SaveControl();
		/// End SAVE_CHECKBOX_STATUS
		
		if(m_strThemeFileAllFormats.IsFile())
			DeleteFile(m_strThemeFileAllFormats);
		m_strThemeFileAllFormats.Empty();
		
		return TRUE;
	}
	BOOL OnAdvancedCheck(Control oCntrl)
	{
		bool bCheck = m_btnCheckAdvanced.Check;
		show_controls(bCheck);
		if(bCheck)
			load_theme_to_tree();
		
		//oCntrl.Visible = false;
		return TRUE;
	}
	BOOL OnCheck(Control oCntrl)
	{
		update_tree_view_mode();
		return TRUE;
	}
	BOOL OnNameChange(Control ctrl)
	{
		m_strThemeName = ctrl.Text;
		return TRUE;
	}
	///Jasmine 02/10/10 QA81-15101 SHOW_EXIST_THEMES
	BOOL OnSelName(Control ctrl)
	{
		m_cmbName.GetLBText(m_cmbName.GetCurSel(), m_strThemeName);
		return TRUE;
	}
	///End SHOW_EXIST_THEMES
	BOOL OnThemeFilter(Control ctrl)
	{
		///Frank 9/13/05 v8.0305 REMOVE_DIALOGEX_FROM_THEME_ULTILS	
		//theme_filter_dialog(*this, IDC_SAVETHEME_LIST_VIEW, IDC_SAVETHEME_TREE);
		string strTempThemeFile;
		if(!GetTempFileName(strTempThemeFile))
			return false;
	
		TreeEditor tree = GetItem(IDC_SAVETHEME_TREE);
			
		tree.Save(strTempThemeFile);
		if(theme_filter_dialog(GetSafeHwnd(), strTempThemeFile))
		{
			tree.Load(strTempThemeFile);
			updateViewTree();
		}
		if(strTempThemeFile.IsFile())
			DeleteFile(strTempThemeFile);
		///End REMOVE_DIALOGEX_FROM_THEME_ULTILS	
		
		return TRUE;
	}
	BOOL OnSimpleGroupCheck(Control ctrl)
	{
		updateSimpleGroup();
		return TRUE;
	}
private:
	///Jasmine 02/10/10 QA81-15101 SHOW_EXIST_THEMES
	bool initThemeNameList()
	{
		m_cmbName = GetItem(IDC_SAVETHEME_NAME);
		if(!m_cmbName)
			return false;
		
		StringArray saFiles;
		DWORD dwCtrl = GFL_GET_FIRST_ONLY | GFL_REMOVE_PATH; //finding all, keeping duplicates, not GFL_GET_FIRST_ONLY
		okutil_get_theme_file_list(&saFiles, NULL,  ORIGIN_PATH_UNDEF, m_nThemeType, dwCtrl);
	
		int nSize = saFiles.GetSize();
		for(int ii = 0; ii < nSize; ii++)
		{
			m_cmbName.AddString( GetFileName(saFiles[ii], TRUE) );
		}
		m_cmbName.AddString(m_strThemeName);
		m_cmbName.SelectString(0, m_strThemeName);
		
		return true;
	}
	///End SHOW_EXIST_THEMES
	
	bool hasDescription(string& str)
	{
		str = m_editDescription.Text;
		return str.IsEmpty()? false:true;
	}
	void update_tree_view_mode()
	{
		Button btnListView = GetItem(IDC_SAVETHEME_LIST_VIEW);
		Button btnCollections = GetItem(IDC_SAVETHEME_COLLECTIONS);
		
		btnCollections.Enable = !btnListView.Check;
		DWORD dwViewSettings = theme_update_tree_list_view(btnListView.Check, btnCollections.Check);
				
		m_tree.View = dwViewSettings;
	}
	void updateSimpleGroup()
	{
		uint nSubStyles[] = {IDC_SAVETHEME_FONTS, IDC_SAVETHEME_COLORS, IDC_SAVETHEME_DATAPLOT, IDC_SAVETHEME_BACKGROUD, 0};
		uint nOthers[] = {IDC_SAVETHEME_DIMS, IDC_SAVETHEME_SCALES, IDC_SAVETHEME_TEXT,0};
		if(m_chkAll.Check)
		{
			m_chkAllStyles.Check = false; m_chkAllStyles.Enable = false;
			EnableControls(nSubStyles, false);
			EnableControls(nOthers, false);
		}
		else
		{
			m_chkAllStyles.Enable = true;
			EnableControls(nSubStyles, m_chkAllStyles.Check?false:true);
			EnableControls(nOthers, true);
		}
		if(m_chkAllStyles.Check)
		{
			m_chkAll.Check = false; //m_chkAll.Enable = false;
		}
		//else
		//	m_chkAll.Enable = true;
	}
	void show_controls(bool bAdvanced)
	{
		bool bSimple = !bAdvanced;
		uint nSimpleItems[] = {
			IDC_SAVETHEME_ALL,IDC_SAVETHEME_ALL_STYLES,
			IDC_SAVETHEME_COLORS, IDC_SAVETHEME_FONTS,
			IDC_SAVETHEME_DIMS, IDC_SAVETHEME_SCALES,
			IDC_SAVETHEME_DATAPLOT, IDC_SAVETHEME_BACKGROUD,
			IDC_SAVETHEME_TEXT, IDC_SAVETHEME_SIMPLE_GROUP,
			0};
		uint nAdvancedItems[] = {
			IDC_SAVETHEME_TREE, IDC_SAVETHEME_FILTER,
			IDC_SAVETHEME_LIST_VIEW,IDC_SAVETHEME_COLLECTIONS,IDC_SAVETHEME_CUSTOM_TEXT,
			0};
			
		ShowControls(nSimpleItems, bSimple);
		ShowControls(nAdvancedItems, bAdvanced);

		if(bAdvanced)
		{
			RECT r1;
			m_cntrlSimpleGroup.GetWindowRect(&r1);
			m_wndDlg.ScreenToClient(&r1);
			int ny = PositionControl(IDC_SAVETHEME_CUSTOM_TEXT, r1.left, r1.top);
			StretchControlWide(IDC_SAVETHEME_TREE, r1.left, ny, RECT_WIDTH(r1), 0);
			///DG ENABLE_RESIZING
			RECT rTree;
			GetClientRect(m_tree, rTree);
			if(MIN_TREE_HEIGHT > RECT_HEIGHT(rTree))
			{
				rTree.bottom = rTree.top+MIN_TREE_HEIGHT;
				MoveControl(m_tree, rTree);
			}
			///end ENABLE_RESIZING
			ResizeDlgToBottomOfControl(IDC_SAVETHEME_TREE);
		}
		else
			ResizeDlgToBottomOfControl(IDC_SAVETHEME_SIMPLE_GROUP);
	}
	bool copyThemeAllFormats()
	{
		if(!GetTempFileName(m_strThemeFileAllFormats))
			return false;
		//--- CPY 2/21/05 THEME_SAVE_FORMAT_WKS
		//if(theme_copy_format_to_file(m_strThemeFileAllFormats))
		//	return true;
		m_nPageType = theme_copy_format_to_file(m_strThemeFileAllFormats);
		if(m_nPageType > EXIST_NONE)
			return true;
		//---
		m_strThemeFileAllFormats.Empty();
		return false;	
	}
	void load_theme_to_tree()
	{
		if(m_strThemeFileAllFormats.IsFile())
		{
			string strTempThemeFilename;
			GetTempFileName(strTempThemeFilename);
			if(getFormatsBySimpleGroup(strTempThemeFilename))
			{
				m_tree.Load(strTempThemeFilename);
				DeleteFile(strTempThemeFilename);
			}
			else
				m_tree.Load(m_strThemeFileAllFormats);
				
			update_tree_view_mode();
		}
	}
	bool getFormatsBySimpleGroup(LPCSTR lpcszfilename)
	{
		if(!m_strThemeFileAllFormats.IsFile())
			return false;

		if(m_chkAll.Check)
		{
			CopyFile(m_strThemeFileAllFormats, lpcszfilename);
			return true;
		}

		DWORD dwObjs = 0;
		DWORD dwProps = 0;

		if(m_chkAllStyles.Check)
		{
			theme_combine_filter_bits(SAVETHEME_ALL_STYLES, dwProps, dwObjs);
		}
		else
		{
			if(m_chkFonts.Check)
				theme_combine_filter_bits(SAVETHEME_FONTS, dwProps, dwObjs);

			if(m_chkColors.Check)
				theme_combine_filter_bits(SAVETHEME_COLORS, dwProps, dwObjs);

			if(m_chkPlots.Check)
				theme_combine_filter_bits(SAVETHEME_PLOTS, dwProps, dwObjs);

			if(m_chkBkground.Check)
				theme_combine_filter_bits(SAVETHEME_BACKGROUND, dwProps, dwObjs);
		}

		if(m_chkDimension.Check)
			theme_combine_filter_bits(SAVETHEME_DIMS, dwProps, dwObjs);

		if(m_chkScale.Check)
			theme_combine_filter_bits(SAVETHEME_SCALES, dwProps, dwObjs);

		if(m_chkText.Check)
			theme_combine_filter_bits(SAVETHEME_TEXT, dwProps, dwObjs);
		
		ApplyFilterToTheme(m_strThemeFileAllFormats, lpcszfilename, dwProps, dwObjs);
		return true;
	}
	///Frank 9/13/05 v8.0305 REMOVE_DIALOGEX_FROM_THEME_ULTILS	
	void updateViewTree()
	{
		//theme_filter_dialog(*this, IDC_SAVETHEME_LIST_VIEW, IDC_SAVETHEME_TREE);
		Button btnListView = GetItem(IDC_SAVETHEME_LIST_VIEW);
		bool bListViewCheck  = btnListView.Check;
		
		Button btnCollections = GetItem(IDC_SAVETHEME_COLLECTIONS);
		bool bCollectionsCheck  = btnCollections.Check;

		TreeEditor tree = GetItem(IDC_SAVETHEME_TREE);
		
		DWORD dwSettings = theme_update_tree_list_view(bListViewCheck, bCollectionsCheck);
		tree.View = dwSettings;
	}
	///End REMOVE_DIALOGEX_FROM_THEME_ULTILS	
	
	/// Bill 08/03/2010 ORG-699-P1 SAVE_CHECKBOX_STATUS
	void SaveControl()
	{
		dlg_save_to_registry(STR_DLG_NAME, STR_ADVANCED, m_btnCheckAdvanced.Check);

		dlg_save_to_registry(STR_DLG_NAME, STR_ALL, m_chkAll.Check);

		dlg_save_to_registry(STR_DLG_NAME, STR_ALL_STYLE, m_chkAllStyles.Check);

		dlg_save_to_registry(STR_DLG_NAME, STR_FONTS, m_chkFonts.Check);

		dlg_save_to_registry(STR_DLG_NAME, STR_COLORS, m_chkColors.Check);

		dlg_save_to_registry(STR_DLG_NAME, STR_PLOTS, m_chkPlots.Check);

		dlg_save_to_registry(STR_DLG_NAME, STR_DIMENSION, m_chkDimension.Check);

		dlg_save_to_registry(STR_DLG_NAME, STR_SCALE, m_chkScale.Check);

		dlg_save_to_registry(STR_DLG_NAME, STR_BKGROUND, m_chkBkground.Check);

		dlg_save_to_registry(STR_DLG_NAME, STR_TEXT, m_chkText.Check);

		Button btnListView = GetItem(IDC_SAVETHEME_LIST_VIEW);
		dlg_save_to_registry(STR_DLG_NAME, STR_LIST_VIEW, btnListView.Check);

		Button btnCollections = GetItem(IDC_SAVETHEME_COLLECTIONS);
		dlg_save_to_registry(STR_DLG_NAME, STR_COLLECTIONS, btnCollections.Check);
	}

	void LoadControl()
	{
		DWORD dwValue;

		dlg_load_registry(STR_DLG_NAME, STR_ADVANCED, dwValue, 0);
		m_btnCheckAdvanced.Check = dwValue;

		dlg_load_registry(STR_DLG_NAME, STR_ALL, dwValue, 1);
		m_chkAll.Check = dwValue;

		dlg_load_registry(STR_DLG_NAME, STR_ALL_STYLE, dwValue, 0);
		m_chkAllStyles.Check = dwValue;

		dlg_load_registry(STR_DLG_NAME, STR_FONTS, dwValue, 0);
		m_chkFonts.Check = dwValue;

		dlg_load_registry(STR_DLG_NAME, STR_COLORS, dwValue, 0);
		m_chkColors.Check = dwValue;

		dlg_load_registry(STR_DLG_NAME, STR_PLOTS, dwValue, 0);
		m_chkPlots.Check = dwValue;

		dlg_load_registry(STR_DLG_NAME, STR_DIMENSION, dwValue, 0);
		m_chkDimension.Check = dwValue;

		dlg_load_registry(STR_DLG_NAME, STR_SCALE, dwValue, 0);
		m_chkScale.Check = dwValue;

		dlg_load_registry(STR_DLG_NAME, STR_BKGROUND, dwValue, 0);
		m_chkBkground.Check = dwValue;

		dlg_load_registry(STR_DLG_NAME, STR_TEXT, dwValue, 0);
		m_chkText.Check = dwValue;

		Button btnListView = GetItem(IDC_SAVETHEME_LIST_VIEW);
		dlg_load_registry(STR_DLG_NAME, STR_LIST_VIEW, dwValue, 0);
		btnListView.Check = dwValue;

		Button btnCollections = GetItem(IDC_SAVETHEME_COLLECTIONS);
		dlg_load_registry(STR_DLG_NAME, STR_COLLECTIONS, dwValue, 0);
		btnCollections.Check = dwValue;
	}
	/// End SAVE_CHECKBOX_STATUS
};

#pragma labtalk(2) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS

int SaveFormatAsTheme() 
{
	SaveThemeDlg	SaveTheme();

	int nRet = SaveTheme.DoModalEx();
	return 0;
}

